
function switchTab(tabName) {
  document.querySelectorAll('.tab-content').forEach(tab => tab.style.display = 'none');
  document.querySelectorAll('.tab-button').forEach(btn => btn.classList.remove('active'));
  document.getElementById(tabName).style.display = 'block';
  event.target.classList.add('active');
}

function getSelectedGenericKeywords() {
  const selected = [];
  document.querySelectorAll('.checkbox-group input[type="checkbox"]').forEach(cb => {
    if (cb.checked) selected.push(cb.value.toLowerCase());
  });
  return selected;
}

function validateEmails() {
  const input = document.getElementById('emailInput').value.trim();
  const selectedGenerics = getSelectedGenericKeywords();
  const emails = input.split(/\s|,|\n/).filter(Boolean);
  let resultsHTML = '<table><tr><th>Email</th><th>Status</th><th>Reason</th></tr>';
  window.validationResults = [];

  if (emails.length === 0) {
    document.getElementById('results').innerHTML = '<p>No emails to validate.</p>';
    return;
  }

  emails.forEach(email => {
    let status = 'Valid';
    let reason = '';
    const prefix = email.split('@')[0].toLowerCase();
    if (!/^\S+@\S+\.\S+$/.test(email)) {
      status = 'Invalid';
      reason = 'Invalid format';
    } else if (selectedGenerics.some(gen => prefix.startsWith(gen))) {
      status = 'Skipped';
      reason = 'Generic email';
    }
    resultsHTML += `<tr><td>${email}</td><td>${status}</td><td>${reason}</td></tr>`;
    window.validationResults.push({ email, status, reason });
  });

  resultsHTML += '</table>';
  document.getElementById('results').innerHTML = resultsHTML;
}

function clearEmails() {
  document.getElementById('emailInput').value = '';
  document.getElementById('results').innerHTML = '';
}

function downloadCSV() {
  if (!window.validationResults || window.validationResults.length === 0) {
    alert('No data to download.');
    return;
  }
  let csv = 'Email,Status,Reason\n';
  window.validationResults.forEach(row => {
    csv += `${row.email},${row.status},${row.reason}\n`;
  });
  const blob = new Blob([csv], { type: 'text/csv;charset=utf-8;' });
  const url = URL.createObjectURL(blob);
  const link = document.createElement('a');
  link.setAttribute('href', url);
  link.setAttribute('download', 'validated_emails.csv');
  document.body.appendChild(link);
  link.click();
  document.body.removeChild(link);
}

function savePreferences() {
  const selected = getSelectedGenericKeywords();
  localStorage.setItem('genericKeywords', JSON.stringify(selected));
  alert('Preferences saved.');
}

function resetPreferences() {
  document.querySelectorAll('.checkbox-group input[type="checkbox"]').forEach(cb => cb.checked = false);
}

function loadPreferences() {
  const saved = JSON.parse(localStorage.getItem('genericKeywords') || "[]");
  document.querySelectorAll('.checkbox-group input[type="checkbox"]').forEach(cb => {
    cb.checked = saved.includes(cb.value);
  });
}

document.addEventListener("DOMContentLoaded", () => {
  document.getElementById('btnValidate').addEventListener('click', validateEmails);
  document.getElementById('btnClear').addEventListener('click', clearEmails);
  document.getElementById('btnDownloadCSV').addEventListener('click', downloadCSV);
  document.getElementById('btnSavePrefs').addEventListener('click', savePreferences);
  document.getElementById('btnResetPrefs').addEventListener('click', resetPreferences);

  document.getElementById('tabValidate').addEventListener('click', () => switchTab('validate'));
  document.getElementById('tabExcel').addEventListener('click', () => switchTab('excel'));
  document.getElementById('tabInfo').addEventListener('click', () => switchTab('info'));

  loadPreferences();
});


// Persist textarea content

  const emailInput = document.getElementById('emailInput');
  const savedEmails = localStorage.getItem('emailInput');
  if (savedEmails) {
    emailInput.value = savedEmails;
  }
  emailInput.addEventListener('input', () => {
    localStorage.setItem('emailInput', emailInput.value);
  });
